/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import io.netty.handler.codec.http.HttpResponse;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.lightbody.bmp.filters.ResponseFilter;
import net.lightbody.bmp.util.HttpMessageContents;
import net.lightbody.bmp.util.HttpMessageInfo;

public class ResponseSizeWatchdog
implements ResponseFilter {
    private static final Logger log = Logger.getLogger(ResponseSizeWatchdog.class.getName());
    int threshold = 0x200000;

    public void filterResponse(HttpResponse response, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        if (contents.getBinaryContents().length > this.threshold) {
            log.warning("Too large response " + messageInfo.getUrl() + ": " + contents.getBinaryContents().length + " bytes");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Response content: " + contents.getTextContents());
            }
        }
    }
}

