/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit5;

import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.SelenideLogger;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SoftAssertsExtension
implements BeforeEachCallback,
AfterEachCallback {
    private final ErrorsCollector errorsCollector = new ErrorsCollector();

    public ErrorsCollector getErrorsCollector() {
        return this.errorsCollector;
    }

    public void beforeEach(ExtensionContext context) {
        SelenideLogger.addListener("softAssert", this.errorsCollector);
    }

    public void afterEach(ExtensionContext context) {
        SelenideLogger.removeListener("softAssert");
        this.errorsCollector.failIfErrors(context.getDisplayName());
    }
}

