/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Html;
import org.openqa.selenium.WebElement;

public class ExactTextCaseSensitive
extends Condition {
    private final String expectedText;

    public ExactTextCaseSensitive(String expectedText) {
        super("exact text case sensitive");
        this.expectedText = expectedText;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        return Html.text.equalsCaseSensitive(element.getText(), this.expectedText);
    }

    @Override
    public String toString() {
        return this.getName() + " '" + this.expectedText + '\'';
    }
}

