/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLog;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SelenideLogger {
    protected static ThreadLocal<Map<String, LogEventListener>> listeners = new ThreadLocal();

    public static void addListener(String name, LogEventListener listener) {
        Map<String, LogEventListener> threadListeners = listeners.get();
        if (threadListeners == null) {
            threadListeners = new HashMap<String, LogEventListener>();
        }
        threadListeners.put(name, listener);
        listeners.set(threadListeners);
    }

    public static SelenideLog beginStep(String source, String methodName, Object ... args) {
        return SelenideLogger.beginStep(source, SelenideLogger.readableMethodName(methodName) + "(" + SelenideLogger.readableArguments(args) + ")");
    }

    static String readableMethodName(String methodName) {
        return methodName.replaceAll("([A-Z])", " $1").toLowerCase();
    }

    static String readableArguments(Object ... args) {
        return args == null ? "" : (args[0] instanceof Object[] ? SelenideLogger.arrayToString((Object[])args[0]) : SelenideLogger.arrayToString(args));
    }

    private static String arrayToString(Object[] args) {
        return args.length == 1 ? String.valueOf(args[0]) : Arrays.toString(args);
    }

    public static SelenideLog beginStep(String source, String subject) {
        Collection<LogEventListener> listeners = SelenideLogger.getEventLoggerListeners();
        SelenideLog log = new SelenideLog(source, subject);
        for (LogEventListener listener : listeners) {
            listener.beforeEvent(log);
        }
        return log;
    }

    public static void commitStep(SelenideLog log, Throwable error) {
        log.setError(error);
        SelenideLogger.commitStep(log, LogEvent.EventStatus.FAIL);
    }

    public static void commitStep(SelenideLog log, LogEvent.EventStatus status) {
        log.setStatus(status);
        Collection<LogEventListener> listeners = SelenideLogger.getEventLoggerListeners();
        for (LogEventListener listener : listeners) {
            listener.afterEvent(log);
        }
    }

    private static Collection<LogEventListener> getEventLoggerListeners() {
        if (listeners.get() == null) {
            listeners.set(new HashMap());
        }
        return listeners.get().values();
    }

    public static <T extends LogEventListener> T removeListener(String name) {
        Map<String, LogEventListener> listeners = SelenideLogger.listeners.get();
        return (T)(listeners == null ? null : listeners.remove(name));
    }

    public static void removeAllListeners() {
        listeners.remove();
    }

    public static boolean hasListener(String name) {
        Map<String, LogEventListener> listeners = SelenideLogger.listeners.get();
        return listeners != null && listeners.containsKey(name);
    }
}

