/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Html;
import org.openqa.selenium.WebElement;

public class CaseSensitiveText
extends Condition {
    private final String expectedText;

    public CaseSensitiveText(String expectedText) {
        super("textCaseSensitive");
        this.expectedText = expectedText;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        return Html.text.containsCaseSensitive(element.getText(), this.expectedText);
    }

    @Override
    public String toString() {
        return this.getName() + " '" + this.expectedText + '\'';
    }
}

