/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import org.openqa.selenium.WebElement;

public class SelectedText
extends Condition {
    private final String expectedText;
    private String actualResult = "";

    public SelectedText(String expectedText) {
        super("selectedText");
        this.expectedText = expectedText;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        this.actualResult = (String)driver.executeJavaScript("return arguments[0].value.substring(arguments[0].selectionStart, arguments[0].selectionEnd);", element);
        return this.actualResult.equals(this.expectedText);
    }

    @Override
    public String actualValue(Driver driver, WebElement element) {
        return "'" + this.actualResult + "'";
    }

    @Override
    public String toString() {
        return this.getName() + " '" + this.expectedText + '\'';
    }
}

