/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.math.NumberUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

class ChromeDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(ChromeDriverFactory.class.getName());

    ChromeDriverFactory() {
    }

    @Override
    WebDriver create(Config config, Proxy proxy) {
        ChromeOptions options = this.createChromeOptions(config, proxy);
        return new ChromeDriver(options);
    }

    @Override
    boolean supports(Config config, Browser browser) {
        return browser.isChrome();
    }

    ChromeOptions createChromeOptions(Config config, Proxy proxy) {
        ChromeOptions options = new ChromeOptions();
        options.setHeadless(config.headless());
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: " + config.browserBinary());
            options.setBinary(config.browserBinary());
        }
        options.addArguments(new String[]{"--proxy-bypass-list=<-loopback>"});
        options.merge((Capabilities)this.createCommonCapabilities(config, proxy));
        options = this.transferChromeOptionsFromSystemProperties(options);
        log.config("Chrome options:" + options.toString());
        return options;
    }

    private ChromeOptions transferChromeOptionsFromSystemProperties(ChromeOptions currentChromeOptions) {
        if (System.getProperty("chromeoptions.args") != null) {
            Stream<String> params = Arrays.stream(this.parseCSVhandlingQuotes(System.getProperty("chromeoptions.args")));
            List args = params.map(s -> s.replace("\"", "")).collect(Collectors.toList());
            currentChromeOptions.addArguments(args);
        }
        if (System.getProperty("chromeoptions.prefs") != null) {
            Map<String, Object> prefs = this.parsePreferencesFromString(System.getProperty("chromeoptions.prefs"));
            currentChromeOptions.setExperimentalOption("prefs", prefs);
        }
        return currentChromeOptions;
    }

    private Map<String, Object> parsePreferencesFromString(String preferencesString) {
        String[] allPrefs;
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        for (String pref : allPrefs = this.parseCSVhandlingQuotes(preferencesString)) {
            String[] keyValue = pref.replace("\"", "").split("=");
            if (keyValue.length == 1) {
                log.warning(String.format("Missing '=' sign while parsing <key=value> pairs from %s. Key '%s' is ignored.", preferencesString, keyValue[0]));
                continue;
            }
            if (keyValue.length > 2) {
                log.warning(String.format("More than one '=' sign while parsing <key=value> pairs from %s. Key '%s' is ignored.", preferencesString, keyValue[0]));
                continue;
            }
            Object prefValue = this.convertStringToNearestObjectType(keyValue[1]);
            prefs.put(keyValue[0], prefValue);
        }
        return prefs;
    }

    private String[] parseCSVhandlingQuotes(String csvString) {
        return csvString.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    }

    private Object convertStringToNearestObjectType(String value) {
        switch (value) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        if (NumberUtils.isParsable((String)value)) {
            return Integer.parseInt(value);
        }
        return value;
    }
}

