/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.Cleanup;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class Describe {
    private static final Logger log = Logger.getLogger(Describe.class.getName());
    private final Driver driver;
    private final WebElement element;
    private final StringBuilder sb = new StringBuilder();

    private Describe(Driver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
        this.sb.append('<').append(element.getTagName());
    }

    private Describe appendAttributes() {
        block4: {
            try {
                if (this.supportsJavascriptAttributes()) {
                    return this.appendAllAttributes();
                }
            }
            catch (UnsupportedOperationException | NoSuchElementException | UnsupportedCommandException throwable) {
            }
            catch (WebDriverException probablyBrowserDoesNotSupportJavaScript) {
                if (probablyBrowserDoesNotSupportJavaScript.getMessage().toLowerCase().contains("method is not implemented")) break block4;
                log.warning("Failed to get attributes via JS: " + probablyBrowserDoesNotSupportJavaScript.toString());
            }
        }
        return this.appendPredefinedAttributes();
    }

    private Describe appendAllAttributes() {
        Map map = (Map)this.driver.executeJavaScript("var s = {};var attrs = arguments[0].attributes;for (var i = 0; i < attrs.length; i++) {   var a = attrs[i];    if (a.name != 'style') {     s[a.name] = a.value;   }}return s;", this.element);
        TreeMap<String, String> sortedByName = new TreeMap<String, String>();
        if (map != null) {
            sortedByName.putAll(map);
        }
        sortedByName.put("value", this.element.getAttribute("value"));
        if (!sortedByName.containsKey("type")) {
            sortedByName.put("type", this.element.getAttribute("type"));
        }
        for (Map.Entry entry : sortedByName.entrySet()) {
            this.attr((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    private Describe appendPredefinedAttributes() {
        return this.attr("class").attr("disabled").attr("href").attr("id").attr("name").attr("onclick").attr("onchange").attr("placeholder").attr("type").attr("value");
    }

    private boolean supportsJavascriptAttributes() {
        return this.driver.supportsJavascript() && !this.driver.browser().isHtmlUnit();
    }

    private Describe attr(String attributeName) {
        try {
            String attributeValue = this.element.getAttribute(attributeName);
            return this.attr(attributeName, attributeValue);
        }
        catch (UnsupportedOperationException | NoSuchElementException | UnsupportedCommandException browserDoesNotSupportJavaScript) {
            return this;
        }
        catch (WebDriverException probablyBrowserDoesNotSupportJavaScript) {
            if (!probablyBrowserDoesNotSupportJavaScript.getMessage().toLowerCase().contains("method is not implemented")) {
                log.warning("Failed to get attributes via JS: " + probablyBrowserDoesNotSupportJavaScript.toString());
            }
            return this;
        }
    }

    private Describe attr(String attributeName, String attributeValue) {
        if (attributeValue != null && attributeValue.length() > 0) {
            this.sb.append(' ').append(attributeName).append("=\"").append(attributeValue).append('\"');
        }
        return this;
    }

    private String serialize() {
        String text = this.element.getText();
        this.sb.append('>').append(text == null ? "" : text).append("</").append(this.element.getTagName()).append('>');
        return this.sb.toString();
    }

    public String toString() {
        return this.sb.toString();
    }

    private String flush() {
        return this.sb.append('>').toString();
    }

    public static String describe(Driver driver, WebElement element) {
        try {
            if (element == null) {
                return "null";
            }
            return new Describe(driver, element).appendAttributes().isSelected(element).isDisplayed(element).serialize();
        }
        catch (WebDriverException elementDoesNotExist) {
            return Cleanup.of.webdriverExceptionMessage(elementDoesNotExist);
        }
        catch (IndexOutOfBoundsException e) {
            return e.toString();
        }
    }

    static String shortly(Driver driver, WebElement element) {
        try {
            if (element == null) {
                return "null";
            }
            if (element instanceof SelenideElement) {
                return Describe.shortly(driver, ((SelenideElement)element).toWebElement());
            }
            return new Describe(driver, element).attr("id").attr("name").flush();
        }
        catch (WebDriverException elementDoesNotExist) {
            return Cleanup.of.webdriverExceptionMessage(elementDoesNotExist);
        }
        catch (IndexOutOfBoundsException e) {
            return e.toString();
        }
    }

    private Describe isSelected(WebElement element) {
        try {
            if (element.isSelected()) {
                this.sb.append(' ').append("selected:true");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (InvalidElementStateException invalidElementStateException) {
            // empty catch block
        }
        return this;
    }

    private Describe isDisplayed(WebElement element) {
        try {
            if (!element.isDisplayed()) {
                this.sb.append(' ').append("displayed:false");
            }
        }
        catch (UnsupportedOperationException e) {
            this.sb.append(' ').append("displayed:").append(e);
        }
        catch (InvalidElementStateException e) {
            this.sb.append(' ').append("displayed:").append((Object)e);
        }
        return this;
    }

    static String shortly(By selector) {
        if (selector instanceof By.ByCssSelector) {
            return selector.toString().replaceFirst("By\\.selector:\\s*(.*)", "$1").replaceFirst("By\\.cssSelector:\\s*(.*)", "$1");
        }
        return selector.toString();
    }

    public static String selector(By selector) {
        return selector.toString().replaceFirst("By\\.selector:\\s*", "").replaceFirst("By\\.cssSelector:\\s*", "");
    }
}

