/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;

class FirefoxDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(FirefoxDriverFactory.class.getName());

    FirefoxDriverFactory() {
    }

    @Override
    boolean supports(Config config, Browser browser) {
        return browser.isFirefox();
    }

    @Override
    WebDriver create(Config config, Proxy proxy) {
        String logFilePath = System.getProperty("webdriver.firefox.logfile", "/dev/null");
        System.setProperty("webdriver.firefox.logfile", logFilePath);
        return this.createFirefoxDriver(config, proxy);
    }

    private WebDriver createFirefoxDriver(Config config, Proxy proxy) {
        FirefoxOptions options = this.createFirefoxOptions(config, proxy);
        return new FirefoxDriver(options);
    }

    FirefoxOptions createFirefoxOptions(Config config, Proxy proxy) {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        firefoxOptions.setHeadless(config.headless());
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: " + config.browserBinary());
            firefoxOptions.setBinary(config.browserBinary());
        }
        firefoxOptions.addPreference("network.automatic-ntlm-auth.trusted-uris", "http://,https://");
        firefoxOptions.addPreference("network.automatic-ntlm-auth.allow-non-fqdn", true);
        firefoxOptions.addPreference("network.negotiate-auth.delegation-uris", "http://,https://");
        firefoxOptions.addPreference("network.negotiate-auth.trusted-uris", "http://,https://");
        firefoxOptions.addPreference("network.http.phishy-userpass-length", 255);
        firefoxOptions.addPreference("security.csp.enable", false);
        firefoxOptions.addPreference("network.proxy.no_proxies_on", "");
        firefoxOptions.addPreference("network.proxy.allow_hijacking_localhost", true);
        firefoxOptions.merge((Capabilities)this.createCommonCapabilities(config, proxy));
        firefoxOptions = this.transferFirefoxProfileFromSystemProperties(firefoxOptions);
        return firefoxOptions;
    }

    private FirefoxOptions transferFirefoxProfileFromSystemProperties(FirefoxOptions currentFirefoxOptions) {
        String prefix = "firefoxprofile.";
        FirefoxProfile profile = Optional.ofNullable(currentFirefoxOptions.getProfile()).orElseGet(FirefoxProfile::new);
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            log.config("Use " + key + "=" + value);
            if (value.equals("true") || value.equals("false")) {
                profile.setPreference(capability, Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (value.matches("^-?\\d+$")) {
                profile.setPreference(capability, Integer.parseInt(value));
                continue;
            }
            profile.setPreference(capability, value);
        }
        return currentFirefoxOptions.setProfile(profile);
    }
}

