/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.files;

import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.files.FileFilter;
import org.apache.commons.io.FilenameUtils;

class ExtensionFilter
implements FileFilter {
    private final String extension;

    ExtensionFilter(String extension) {
        this.extension = extension;
    }

    @Override
    public boolean match(DownloadedFile file) {
        return FilenameUtils.isExtension((String)file.getFile().getName(), (String)this.extension);
    }

    @Override
    public String description() {
        return "with extension \"" + this.extension + "\"";
    }

    public String toString() {
        return this.description();
    }
}

