/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.impl.DurationFormat;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLog;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SelenideLogger {
    private static final Logger LOG = LoggerFactory.getLogger(SelenideLogger.class);
    protected static final ThreadLocal<Map<String, LogEventListener>> listeners = new ThreadLocal();
    private static final DurationFormat df = new DurationFormat();

    public static void addListener(String name, LogEventListener listener) {
        Map<String, LogEventListener> threadListeners = listeners.get();
        if (threadListeners == null) {
            threadListeners = new HashMap<String, LogEventListener>();
        }
        threadListeners.put(name, listener);
        listeners.set(threadListeners);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideLog beginStep(String source, String methodName, Object ... args) {
        return SelenideLogger.beginStep(source, SelenideLogger.readableMethodName(methodName) + "(" + SelenideLogger.readableArguments(args) + ")");
    }

    @CheckReturnValue
    @Nonnull
    static String readableMethodName(String methodName) {
        return methodName.replaceAll("([A-Z])", " $1").toLowerCase();
    }

    @CheckReturnValue
    @Nonnull
    static String readableArguments(Object ... args) {
        if (args == null || args.length == 0) {
            return "";
        }
        if (args[0] instanceof Object[]) {
            return SelenideLogger.arrayToString((Object[])args[0]);
        }
        if (args[0] instanceof int[]) {
            return SelenideLogger.arrayToString((int[])args[0]);
        }
        return SelenideLogger.arrayToString(args);
    }

    @CheckReturnValue
    @Nonnull
    private static String arrayToString(Object[] args) {
        return args.length == 1 ? SelenideLogger.argToString(args[0]) : '[' + Stream.of(args).map(SelenideLogger::argToString).collect(Collectors.joining(", ")) + ']';
    }

    private static String argToString(Object arg) {
        if (arg instanceof Duration) {
            return df.format((Duration)arg);
        }
        return String.valueOf(arg);
    }

    @CheckReturnValue
    @Nonnull
    private static String arrayToString(int[] args) {
        return args.length == 1 ? String.valueOf(args[0]) : Arrays.toString(args);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideLog beginStep(String source, String subject) {
        Collection<LogEventListener> listeners = SelenideLogger.getEventLoggerListeners();
        SelenideLog log = new SelenideLog(source, subject);
        for (LogEventListener listener : listeners) {
            try {
                listener.beforeEvent(log);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to call listener {}", (Object)listener, (Object)e);
            }
        }
        return log;
    }

    public static void commitStep(SelenideLog log, Throwable error) {
        log.setError(error);
        SelenideLogger.commitStep(log, LogEvent.EventStatus.FAIL);
    }

    public static void commitStep(SelenideLog log, LogEvent.EventStatus status) {
        log.setStatus(status);
        Collection<LogEventListener> listeners = SelenideLogger.getEventLoggerListeners();
        for (LogEventListener listener : listeners) {
            try {
                listener.afterEvent(log);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to call listener {}", (Object)listener, (Object)e);
            }
        }
    }

    public static void run(String source, String subject, Runnable runnable) {
        SelenideLog log = SelenideLogger.beginStep(source, subject);
        try {
            runnable.run();
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
        }
        catch (Error | RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    public static <T> T get(String source, @Nullable String subject, Supplier<T> supplier) {
        SelenideLog log = SelenideLogger.beginStep(source, subject);
        try {
            T result = supplier.get();
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return result;
        }
        catch (Error | RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    @CheckReturnValue
    @Nonnull
    private static Collection<LogEventListener> getEventLoggerListeners() {
        if (listeners.get() == null) {
            listeners.set(new HashMap());
        }
        return listeners.get().values();
    }

    @Nullable
    public static <T extends LogEventListener> T removeListener(String name) {
        Map<String, LogEventListener> listeners = SelenideLogger.listeners.get();
        return (T)(listeners == null ? null : listeners.remove(name));
    }

    public static void removeAllListeners() {
        listeners.remove();
    }

    public static boolean hasListener(String name) {
        Map<String, LogEventListener> listeners = SelenideLogger.listeners.get();
        return listeners != null && listeners.containsKey(name);
    }
}

