/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.LocalStorage;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.SelenideWait;
import com.codeborne.selenide.SessionStorage;
import com.codeborne.selenide.WebDriverRunner;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

@ParametersAreNonnullByDefault
public class Selenide {
    public static void open(String relativeOrAbsoluteUrl) {
        WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl);
    }

    public static void open(URL absoluteUrl) {
        WebDriverRunner.getSelenideDriver().open(absoluteUrl);
    }

    public static void open(String relativeOrAbsoluteUrl, String domain, String login, String password) {
        WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, domain, login, password);
    }

    public static void open(String relativeOrAbsoluteUrl, AuthenticationType authenticationType, String login, String password) {
        Credentials credentials = new Credentials(login, password);
        Selenide.open(relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    public static void open(String relativeOrAbsoluteUrl, AuthenticationType authenticationType, Credentials credentials) {
        WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    public static void open(URL absoluteUrl, String domain, String login, String password) {
        WebDriverRunner.getSelenideDriver().open(absoluteUrl, domain, login, password);
    }

    public static void open() {
        WebDriverRunner.getSelenideDriver().open();
    }

    public static void using(WebDriver webDriver, Runnable lambda) {
        WebDriverRunner.using(webDriver, lambda);
    }

    public static void updateHash(String hash) {
        WebDriverRunner.getSelenideDriver().updateHash(hash);
    }

    @CheckReturnValue
    @Nonnull
    public static <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, pageObjectClassClass);
    }

    @CheckReturnValue
    @Nonnull
    public static <PageObjectClass> PageObjectClass open(URL absoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return WebDriverRunner.getSelenideDriver().open(absoluteUrl, pageObjectClassClass);
    }

    @CheckReturnValue
    @Nonnull
    public static <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        return WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, domain, login, password, pageObjectClassClass);
    }

    @CheckReturnValue
    @Nonnull
    public static <PageObjectClass> PageObjectClass open(URL absoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        return WebDriverRunner.getSelenideDriver().open(absoluteUrl, domain, login, password, pageObjectClassClass);
    }

    public static void closeWindow() {
        WebDriverRunner.closeWindow();
    }

    public static void closeWebDriver() {
        WebDriverRunner.closeWebDriver();
    }

    @Deprecated
    public static void close() {
        Selenide.closeWebDriver();
    }

    public static void refresh() {
        WebDriverRunner.getSelenideDriver().refresh();
    }

    public static void back() {
        WebDriverRunner.getSelenideDriver().back();
    }

    public static void forward() {
        WebDriverRunner.getSelenideDriver().forward();
    }

    @CheckReturnValue
    @Nullable
    public static String title() {
        return WebDriverRunner.getSelenideDriver().title();
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @CheckReturnValue
    @Nullable
    public static String screenshot(String fileName) {
        return WebDriverRunner.getSelenideDriver().screenshot(fileName);
    }

    @CheckReturnValue
    @Nullable
    public static <T> T screenshot(OutputType<T> outputType) {
        return WebDriverRunner.getSelenideDriver().screenshot(outputType);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement $(WebElement webElement) {
        return WebDriverRunner.getSelenideDriver().$(webElement);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement $(String cssSelector) {
        return WebDriverRunner.getSelenideDriver().find(cssSelector);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement $x(String xpathExpression) {
        return WebDriverRunner.getSelenideDriver().$x(xpathExpression);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement $(By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().find(seleniumSelector);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement $(By seleniumSelector, int index) {
        return WebDriverRunner.getSelenideDriver().find(seleniumSelector, index);
    }

    @Deprecated
    @Nonnull
    public static SelenideElement $(WebElement parent, String cssSelector) {
        return WebDriverRunner.getSelenideDriver().$(parent).find(cssSelector);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement $(String cssSelector, int index) {
        return WebDriverRunner.getSelenideDriver().$(cssSelector, index);
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public static SelenideElement $(WebElement parent, String cssSelector, int index) {
        return WebDriverRunner.getSelenideDriver().$(parent).find(cssSelector, index);
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public static SelenideElement $(WebElement parent, By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().$(parent).find(seleniumSelector);
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public static SelenideElement $(WebElement parent, By seleniumSelector, int index) {
        return WebDriverRunner.getSelenideDriver().$(parent).find(seleniumSelector, index);
    }

    @CheckReturnValue
    @Nonnull
    public static ElementsCollection $$(Collection<? extends WebElement> elements) {
        return WebDriverRunner.getSelenideDriver().$$(elements);
    }

    @CheckReturnValue
    @Nonnull
    public static ElementsCollection $$(String cssSelector) {
        return WebDriverRunner.getSelenideDriver().$$(cssSelector);
    }

    @CheckReturnValue
    @Nonnull
    public static ElementsCollection $$x(String xpathExpression) {
        return WebDriverRunner.getSelenideDriver().$$x(xpathExpression);
    }

    @CheckReturnValue
    @Nonnull
    public static ElementsCollection $$(By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().$$(seleniumSelector);
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public static ElementsCollection $$(WebElement parent, String cssSelector) {
        return WebDriverRunner.getSelenideDriver().$(parent).findAll(cssSelector);
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public static ElementsCollection $$(WebElement parent, By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().$(parent).findAll(seleniumSelector);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement element(WebElement webElement) {
        return WebDriverRunner.getSelenideDriver().$(webElement);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement element(String cssSelector) {
        return WebDriverRunner.getSelenideDriver().$(cssSelector);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement element(By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().$(seleniumSelector);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement element(By seleniumSelector, int index) {
        return WebDriverRunner.getSelenideDriver().$(seleniumSelector, index);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement element(String cssSelector, int index) {
        return WebDriverRunner.getSelenideDriver().$(cssSelector, index);
    }

    @CheckReturnValue
    @Nonnull
    public static ElementsCollection elements(Collection<? extends WebElement> elements) {
        return WebDriverRunner.getSelenideDriver().$$(elements);
    }

    @CheckReturnValue
    @Nonnull
    public static ElementsCollection elements(String cssSelector) {
        return WebDriverRunner.getSelenideDriver().$$(cssSelector);
    }

    @CheckReturnValue
    @Nonnull
    public static ElementsCollection elements(By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().$$(seleniumSelector);
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public static SelenideElement getElement(By criteria) {
        return WebDriverRunner.getSelenideDriver().find(criteria);
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public static SelenideElement getElement(By criteria, int index) {
        return WebDriverRunner.getSelenideDriver().find(criteria, index);
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public static ElementsCollection getElements(By criteria) {
        return WebDriverRunner.getSelenideDriver().findAll(criteria);
    }

    @Nullable
    public static <T> T executeJavaScript(String jsCode, Object ... arguments) {
        return WebDriverRunner.getSelenideDriver().executeJavaScript(jsCode, arguments);
    }

    @Nullable
    public static <T> T executeAsyncJavaScript(String jsCode, Object ... arguments) {
        return WebDriverRunner.getSelenideDriver().executeAsyncJavaScript(jsCode, arguments);
    }

    @CheckReturnValue
    @Nullable
    public static SelenideElement getSelectedRadio(By radioField) {
        return WebDriverRunner.getSelenideDriver().getSelectedRadio(radioField);
    }

    @Nullable
    public static String confirm() {
        return WebDriverRunner.getSelenideDriver().modal().confirm();
    }

    @Nullable
    public static String confirm(@Nullable String expectedDialogText) {
        return WebDriverRunner.getSelenideDriver().modal().confirm(expectedDialogText);
    }

    @Nullable
    public static String prompt() {
        return WebDriverRunner.getSelenideDriver().modal().prompt();
    }

    @Nullable
    public static String prompt(@Nullable String inputText) {
        return WebDriverRunner.getSelenideDriver().modal().prompt(inputText);
    }

    @Nullable
    public static String prompt(@Nullable String expectedDialogText, @Nullable String inputText) {
        return WebDriverRunner.getSelenideDriver().modal().prompt(expectedDialogText, inputText);
    }

    @Nullable
    public static String dismiss() {
        return WebDriverRunner.getSelenideDriver().modal().dismiss();
    }

    @Nullable
    public static String dismiss(@Nullable String expectedDialogText) {
        return WebDriverRunner.getSelenideDriver().modal().dismiss(expectedDialogText);
    }

    @Nonnull
    @CheckReturnValue
    public static SelenideTargetLocator switchTo() {
        return WebDriverRunner.getSelenideDriver().driver().switchTo();
    }

    @CheckReturnValue
    @Nullable
    public static WebElement getFocusedElement() {
        return WebDriverRunner.getSelenideDriver().getFocusedElement();
    }

    @CheckReturnValue
    @Nonnull
    public static <PageObjectClass> PageObjectClass page(Class<PageObjectClass> pageObjectClass) {
        return WebDriverRunner.getSelenideDriver().page(pageObjectClass);
    }

    @CheckReturnValue
    @Nonnull
    public static <PageObjectClass, T extends PageObjectClass> PageObjectClass page(T pageObject) {
        return WebDriverRunner.getSelenideDriver().page(pageObject);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideWait Wait() {
        return WebDriverRunner.getSelenideDriver().Wait();
    }

    @CheckReturnValue
    @Nonnull
    public static Actions actions() {
        return WebDriverRunner.getSelenideDriver().driver().actions();
    }

    public static void zoom(double factor) {
        WebDriverRunner.getSelenideDriver().zoom(factor);
    }

    @CheckReturnValue
    @Nonnull
    public static List<String> getWebDriverLogs(String logType) {
        return WebDriverRunner.getSelenideDriver().getWebDriverLogs().logs(logType);
    }

    @Nonnull
    @CheckReturnValue
    public static List<String> getWebDriverLogs(String logType, Level logLevel) {
        return WebDriverRunner.getSelenideDriver().getWebDriverLogs().logs(logType, logLevel);
    }

    public static void clearBrowserCookies() {
        WebDriverRunner.getSelenideDriver().clearCookies();
    }

    public static void clearBrowserLocalStorage() {
        WebDriverRunner.getSelenideDriver().clearBrowserLocalStorage();
    }

    @Nonnull
    @CheckReturnValue
    public static String getUserAgent() {
        return WebDriverRunner.getSelenideDriver().driver().getUserAgent();
    }

    @CheckReturnValue
    public static boolean atBottom() {
        return WebDriverRunner.getSelenideDriver().atBottom();
    }

    @Nonnull
    @CheckReturnValue
    public static File download(String url) throws IOException, URISyntaxException {
        return WebDriverRunner.getSelenideDriver().download(url);
    }

    @Nonnull
    @CheckReturnValue
    public static File download(URI url) throws IOException {
        return WebDriverRunner.getSelenideDriver().download(url);
    }

    @Nonnull
    @CheckReturnValue
    public static File download(URI url, long timeoutMs) throws IOException {
        return WebDriverRunner.getSelenideDriver().download(url, timeoutMs);
    }

    @Nonnull
    @CheckReturnValue
    public static File download(String url, long timeoutMs) throws IOException, URISyntaxException {
        return WebDriverRunner.getSelenideDriver().download(new URI(url), timeoutMs);
    }

    @Nonnull
    @CheckReturnValue
    public static LocalStorage localStorage() {
        return WebDriverRunner.getSelenideDriver().getLocalStorage();
    }

    @Nonnull
    @CheckReturnValue
    public static SessionStorage sessionStorage() {
        return WebDriverRunner.getSelenideDriver().getSessionStorage();
    }

    @Nonnull
    @CheckReturnValue
    public static Clipboard clipboard() {
        return WebDriverRunner.getSelenideDriver().getClipboard();
    }
}

