/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.PageSourceExtractor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Alert;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class WebPageSourceExtractor
implements PageSourceExtractor {
    private static final Logger log = LoggerFactory.getLogger(WebPageSourceExtractor.class);
    private final Set<String> printedErrors = new ConcurrentSkipListSet<String>();

    @Override
    @Nonnull
    @CheckReturnValue
    public File extract(Config config, WebDriver driver, String fileName) {
        return this.extract(config, driver, fileName, true);
    }

    private File extract(Config config, WebDriver driver, String fileName, boolean retryIfAlert) {
        File pageSource = this.createFile(config, fileName);
        try {
            this.writeToFile(driver.getPageSource(), pageSource);
        }
        catch (UnhandledAlertException e) {
            if (retryIfAlert) {
                this.retryingExtractionOnAlert(config, driver, fileName, (Exception)((Object)e));
            } else {
                this.printOnce("savePageSourceToFile", e);
            }
        }
        catch (WebDriverException e) {
            log.warn("Failed to save page source to {}", (Object)fileName, (Object)e);
            this.writeToFile(e.toString(), pageSource);
            return pageSource;
        }
        catch (RuntimeException e) {
            log.error("Failed to save page source to {}", (Object)fileName, (Object)e);
            this.writeToFile(e.toString(), pageSource);
        }
        return pageSource;
    }

    @Nonnull
    protected File createFile(Config config, String fileName) {
        return new File(config.reportsFolder(), fileName + ".html").getAbsoluteFile();
    }

    protected void writeToFile(String content, File targetFile) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            FileHelper.copyFile(in, targetFile);
        }
        catch (IOException e) {
            log.error("Failed to write file {}", (Object)targetFile.getAbsolutePath(), (Object)e);
        }
    }

    protected synchronized void printOnce(String action, Throwable error) {
        if (!this.printedErrors.contains(action)) {
            log.error(error.getMessage(), error);
            this.printedErrors.add(action);
        } else {
            log.error("Failed to {}: {}", (Object)action, (Object)error);
        }
    }

    private void retryingExtractionOnAlert(Config config, WebDriver driver, String fileName, Exception e) {
        try {
            Alert alert = driver.switchTo().alert();
            log.error("{}: {}", (Object)e, (Object)alert.getText());
            alert.accept();
            this.extract(config, driver, fileName, false);
        }
        catch (Exception unableToCloseAlert) {
            log.error("Failed to close alert", (Throwable)unableToCloseAlert);
        }
    }
}

