/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Html;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

@ParametersAreNonnullByDefault
public class Text
extends Condition {
    protected final String text;

    public Text(String text) {
        super("text");
        this.text = text;
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("Argument must not be null or empty string. Use $.shouldBe(empty) or $.shouldHave(exactText(\"\").");
        }
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        String elementText = "select".equalsIgnoreCase(element.getTagName()) ? this.getSelectedOptionsTexts(element) : element.getText();
        return Html.text.contains(elementText, this.text.toLowerCase());
    }

    private String getSelectedOptionsTexts(WebElement element) {
        List selectedOptions = new Select(element).getAllSelectedOptions();
        return selectedOptions.stream().map(WebElement::getText).collect(Collectors.joining());
    }

    @Override
    public String toString() {
        return String.format("%s '%s'", this.getName(), this.text);
    }
}

