/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit5;

import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

@ParametersAreNonnullByDefault
public class SoftAssertsExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    public static final ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{SoftAssertsExtension.class});

    public void beforeAll(ExtensionContext context) {
        this.getErrorsCollector(context).ifPresent(collector -> {
            throw new IllegalStateException("Errors collector already exists: " + collector);
        });
        ErrorsCollector errorsCollector = new ErrorsCollector();
        SelenideLogger.addListener("softAssert", errorsCollector);
        context.getStore(namespace).put((Object)"softAssert", (Object)errorsCollector);
    }

    public void beforeEach(ExtensionContext context) {
        this.getErrorsCollector(context).map(collector -> {
            SelenideLogger.addListener("softAssert", collector);
            return collector;
        }).orElseThrow(() -> new IllegalStateException("Errors collector doesn't exist"));
    }

    public void afterEach(ExtensionContext context) {
        this.getErrorsCollector(context).ifPresent(collector -> collector.failIfErrors(context.getDisplayName()));
    }

    public void afterAll(ExtensionContext context) {
        SelenideLogger.removeListener("softAssert");
        ErrorsCollector errorsCollector = (ErrorsCollector)context.getStore(namespace).remove((Object)"softAssert");
        if (errorsCollector != null) {
            errorsCollector.failIfErrors(context.getDisplayName());
        }
    }

    @Nonnull
    private Optional<ErrorsCollector> getErrorsCollector(ExtensionContext context) {
        return Optional.ofNullable((ErrorsCollector)context.getStore(namespace).get((Object)"softAssert", ErrorsCollector.class));
    }
}

