/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class FileContent {
    private final String filePath;
    private String content;

    public FileContent(String filePath) {
        this.filePath = filePath;
    }

    public synchronized String content() {
        if (this.content == null) {
            try {
                URL sizzleJs = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource(this.filePath));
                this.content = IOUtils.toString((URL)sizzleJs, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot load " + this.filePath + " from classpath", e);
            }
        }
        return this.content;
    }
}

