/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.JavaScript;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ByShadow {
    private static final JavaScript jsSource = new JavaScript("find-in-shadow-roots.js");

    @CheckReturnValue
    @Nonnull
    public static By cssSelector(String target, String shadowHost, String ... innerShadowHosts) {
        return new ByShadowCss(target, shadowHost, innerShadowHosts);
    }

    @ParametersAreNonnullByDefault
    public static class ByShadowCss
    extends By
    implements Serializable {
        private final List<String> shadowHostsChain;
        private final String target;

        ByShadowCss(String target, String shadowHost, String ... innerShadowHosts) {
            if (shadowHost == null || target == null) {
                throw new IllegalArgumentException("Cannot find elements when the selector is null");
            }
            this.shadowHostsChain = new ArrayList<String>(1 + innerShadowHosts.length);
            this.shadowHostsChain.add(shadowHost);
            this.shadowHostsChain.addAll(Arrays.asList(innerShadowHosts));
            this.target = target;
        }

        @CheckReturnValue
        @Nonnull
        public WebElement findElement(SearchContext context) {
            List<WebElement> found = this.findElements(context);
            if (found.isEmpty()) {
                throw new NoSuchElementException("Cannot locate an element " + this.target + " in shadow roots " + this.describeShadowRoots());
            }
            return found.get(0);
        }

        @CheckReturnValue
        @Nonnull
        public List<WebElement> findElements(SearchContext context) {
            try {
                if (context instanceof WebElement) {
                    return (List)jsSource.execute(context, this.target, this.shadowHostsChain, context);
                }
                return (List)jsSource.execute(context, this.target, this.shadowHostsChain);
            }
            catch (JavascriptException e) {
                throw new NoSuchElementException(Cleanup.of.webdriverExceptionMessage(e));
            }
        }

        @CheckReturnValue
        @Nonnull
        public String toString() {
            return "By.cssSelector: " + this.describeShadowRoots() + " -> " + this.target;
        }

        @CheckReturnValue
        @Nonnull
        private String describeShadowRoots() {
            return this.shadowHostsChain.stream().collect(Collectors.joining(" -> "));
        }
    }
}

