/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.ObjectCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class CurrentFrameUrl
implements ObjectCondition<WebDriver> {
    private final String expectedUrl;

    public CurrentFrameUrl(String expectedUrl) {
        this.expectedUrl = expectedUrl;
    }

    @Override
    @Nonnull
    public String description() {
        return "should have url " + this.expectedUrl;
    }

    @Override
    @Nonnull
    public String negativeDescription() {
        return "should not have url " + this.expectedUrl;
    }

    @Override
    public boolean test(WebDriver webDriver) {
        return CurrentFrameUrl.getCurrentFrameUrl(webDriver).equals(this.expectedUrl);
    }

    @Override
    @Nullable
    public String actualValue(WebDriver webDriver) {
        return CurrentFrameUrl.getCurrentFrameUrl(webDriver);
    }

    @CheckReturnValue
    @Nonnull
    private static String getCurrentFrameUrl(WebDriver webDriver) {
        return ((JavascriptExecutor)webDriver).executeScript("return window.location.href", new Object[0]).toString();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(WebDriver webDriver) {
        return "current frame";
    }
}

