/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.ObjectCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.WebDriver;

public class UrlContaining
implements ObjectCondition<WebDriver> {
    private final String expectedUrl;

    public UrlContaining(String expectedUrl) {
        this.expectedUrl = expectedUrl;
    }

    @Override
    @Nonnull
    public String description() {
        return "should have url containing " + this.expectedUrl;
    }

    @Override
    @Nonnull
    public String negativeDescription() {
        return "should not have url containing " + this.expectedUrl;
    }

    @Override
    public boolean test(WebDriver webDriver) {
        return webDriver.getCurrentUrl().contains(this.expectedUrl);
    }

    @Override
    @Nullable
    public String actualValue(WebDriver webDriver) {
        return webDriver.getCurrentUrl();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(WebDriver webDriver) {
        return "webdriver";
    }
}

