/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class TailOfCollection
implements CollectionSource {
    private final CollectionSource originalCollection;
    private final int size;
    private Alias alias = Alias.NONE;

    public TailOfCollection(CollectionSource originalCollection, int size) {
        this.originalCollection = originalCollection;
        this.size = size;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        List<WebElement> source = this.originalCollection.getElements();
        int sourceCollectionSize = source.size();
        return source.subList(this.startingIndex(sourceCollectionSize), sourceCollectionSize);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getElement(int index) {
        List<WebElement> source = this.originalCollection.getElements();
        int sourceCollectionSize = source.size();
        int startingIndex = this.startingIndex(sourceCollectionSize);
        return this.originalCollection.getElement(startingIndex + index);
    }

    private int startingIndex(int sourceCollectionSize) {
        return sourceCollectionSize - Math.min(sourceCollectionSize, this.size);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String description() {
        return this.alias.getOrElse(() -> this.originalCollection.description() + ":last(" + this.size + ')');
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.originalCollection.driver();
    }

    @Override
    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }
}

