/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.impl.Waiter;
import java.time.Duration;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface Conditional<T> {
    @Nonnull
    @CheckReturnValue
    public Driver driver();

    @Nonnull
    @CheckReturnValue
    public T object();

    default public Conditional<T> shouldHave(ObjectCondition<T> predicate) {
        new Waiter().wait(this.driver(), this.object(), predicate);
        return this;
    }

    default public Conditional<T> shouldHave(ObjectCondition<T> predicate, Duration timeout) {
        new Waiter().wait(this.driver(), this.object(), predicate, timeout);
        return this;
    }

    default public Conditional<T> shouldNotHave(ObjectCondition<T> predicate) {
        new Waiter().waitWhile(this.driver(), this.object(), predicate);
        return this;
    }

    default public Conditional<T> shouldNotHave(ObjectCondition<T> predicate, Duration timeout) {
        new Waiter().waitWhile(this.driver(), this.object(), predicate, timeout);
        return this;
    }
}

