/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.ObjectCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.WebDriver;

public abstract class UrlCondition
implements ObjectCondition<WebDriver> {
    protected final String name;
    protected final String expectedUrl;

    protected UrlCondition(String name, String expectedUrl) {
        this.name = name;
        this.expectedUrl = expectedUrl;
    }

    @Override
    @Nullable
    public String actualValue(WebDriver webDriver) {
        return webDriver.getCurrentUrl();
    }

    @Override
    @Nonnull
    public String description() {
        return "should have url " + this.name + this.expectedUrl;
    }

    @Override
    @Nonnull
    public String negativeDescription() {
        return "should not have url " + this.name + this.expectedUrl;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(WebDriver webDriver) {
        return "webdriver";
    }
}

