/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsContainer;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.PageObjectException;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.PageObjectFactory;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.WebElementSelector;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.AbstractList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;

@ParametersAreNonnullByDefault
public class ElementsContainerCollection
extends AbstractList<ElementsContainer> {
    private final WebElementSelector elementSelector = Plugins.inject(WebElementSelector.class);
    private final PageObjectFactory pageFactory;
    private final Driver driver;
    private final WebElementSource parent;
    private final Field field;
    private final Class<?> listType;
    private final Type[] genericTypes;
    private final By selector;

    public ElementsContainerCollection(PageObjectFactory pageFactory, Driver driver, @Nullable WebElementSource parent, Field field, Class<?> listType, Type[] genericTypes, By selector) {
        this.pageFactory = pageFactory;
        this.driver = driver;
        this.parent = parent;
        this.field = field;
        this.listType = listType;
        this.genericTypes = genericTypes;
        this.selector = selector;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public ElementsContainer get(int index) {
        ElementFinder self = new ElementFinder(this.driver, this.parent, this.selector, index);
        try {
            return this.pageFactory.initElementsContainer(this.driver, this.field, self, this.listType, this.genericTypes);
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to initialize field " + this.field, e);
        }
    }

    @Override
    @CheckReturnValue
    public int size() {
        try {
            return this.elementSelector.findElements(this.driver, this.parent, this.selector).size();
        }
        catch (NoSuchElementException e) {
            throw new ElementNotFound(this.driver, this.selector.toString(), Condition.exist, e);
        }
    }
}

