/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.ex.DoesNotContainTextsError;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ContainExactTextsCaseSensitive
extends CollectionCondition {
    private final List<String> expectedTexts;

    public ContainExactTextsCaseSensitive(String ... expectedTexts) {
        this(Arrays.asList(expectedTexts));
    }

    public ContainExactTextsCaseSensitive(List<String> expectedTexts) {
        if (expectedTexts.isEmpty()) {
            throw new IllegalArgumentException("No expected texts given");
        }
        this.expectedTexts = Collections.unmodifiableList(expectedTexts);
    }

    @Override
    @CheckReturnValue
    public boolean test(List<WebElement> elements) {
        if (elements.size() < this.expectedTexts.size()) {
            return false;
        }
        return ElementsCollection.texts(elements).containsAll(this.expectedTexts);
    }

    @Override
    public void fail(CollectionSource collection, @Nullable List<WebElement> elements, @Nullable Exception lastError, long timeoutMs) {
        if (elements == null || elements.isEmpty()) {
            ElementNotFound elementNotFound = new ElementNotFound(collection, this.toString(), (Throwable)lastError);
            elementNotFound.timeoutMs = timeoutMs;
            throw elementNotFound;
        }
        List<String> actualTexts = ElementsCollection.texts(elements);
        ArrayList<String> difference = new ArrayList<String>(this.expectedTexts);
        difference.removeAll(actualTexts);
        throw new DoesNotContainTextsError(collection, actualTexts, this.expectedTexts, difference, this.explanation, timeoutMs, lastError);
    }

    @Override
    public boolean missingElementSatisfiesCondition() {
        return false;
    }

    public String toString() {
        return "Contains exact texts case-sensitive " + this.expectedTexts;
    }
}

