/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.commands.GetOwnText;
import com.codeborne.selenide.impl.Html;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ExactOwnText
extends Condition {
    private final String expectedText;

    public ExactOwnText(String expectedText) {
        super("exact own text");
        this.expectedText = expectedText;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        return Html.text.equals(GetOwnText.getOwnText(driver, element), this.expectedText);
    }

    @Override
    public String toString() {
        return String.format("%s '%s'", this.getName(), this.expectedText);
    }

    @Override
    @Nullable
    public String actualValue(Driver driver, WebElement element) {
        return GetOwnText.getOwnText(driver, element);
    }
}

