/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.conditions.Not;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Or
extends Condition {
    private final List<? extends Condition> conditions;

    public Or(String name, List<? extends Condition> conditions) {
        super(name, Or.checkedConditionsListCtorArg(conditions).stream().anyMatch(Condition::missingElementSatisfiesCondition));
        this.conditions = conditions;
    }

    private static List<? extends Condition> checkedConditionsListCtorArg(List<? extends Condition> conditions) {
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("conditions list is empty");
        }
        return conditions;
    }

    @Override
    @Nonnull
    public Condition negate() {
        return new Not(this, this.conditions.stream().map(Condition::negate).anyMatch(Condition::missingElementSatisfiesCondition));
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        for (Condition condition : this.conditions) {
            if (!condition.apply(driver, element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String actualValue(Driver driver, WebElement element) {
        return this.conditions.stream().map(condition -> condition.actualValue(driver, element)).collect(Collectors.joining(", "));
    }

    @Override
    public String toString() {
        return this.getName() + ": " + this.conditions.stream().map(Condition::toString).collect(Collectors.joining(" or "));
    }
}

