/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.sessionstorage;

import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.SessionStorage;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ItemWithValue
implements ObjectCondition<SessionStorage> {
    private final String item;
    private final String value;

    public ItemWithValue(String item, String value) {
        this.item = item;
        this.value = value;
    }

    @Override
    @Nonnull
    public String description() {
        return String.format("should have item '%s' with value '%s'", this.item, this.value);
    }

    @Override
    @Nonnull
    public String negativeDescription() {
        return String.format("should not have item '%s' with value '%s'", this.item, this.value);
    }

    @Override
    @Nullable
    public String actualValue(SessionStorage sessionStorage) {
        return sessionStorage.getItems().toString();
    }

    @Override
    public boolean test(SessionStorage sessionStorage) {
        return Objects.equals(sessionStorage.getItem(this.item), this.value);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(SessionStorage sessionStorage) {
        return "sessionStorage";
    }
}

