/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import java.lang.reflect.Field;
import java.time.Duration;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.netty.NettyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class HttpClientTimeouts {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientTimeouts.class);
    public static Duration defaultConnectTimeout = Duration.ofSeconds(10L);
    public static Duration defaultReadTimeout = Duration.ofSeconds(90L);

    HttpClientTimeouts() {
    }

    public void setup(WebDriver webDriver) {
        this.setup(webDriver, defaultConnectTimeout, defaultReadTimeout);
    }

    public void setup(WebDriver webDriver, Duration connectTimeout, Duration readTimeout) {
        if (webDriver instanceof RemoteWebDriver) {
            try {
                this.setupTimeouts((RemoteWebDriver)webDriver, connectTimeout, readTimeout);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to setup Selenium HttpClient timeouts", e);
            }
        }
    }

    private void setupTimeouts(RemoteWebDriver webDriver, Duration connectTimeout, Duration readTimeout) throws Exception {
        CommandExecutor executor = webDriver.getCommandExecutor();
        if (executor instanceof HttpCommandExecutor) {
            this.setupTimeouts((HttpCommandExecutor)executor, connectTimeout, readTimeout);
        }
    }

    private void setupTimeouts(HttpCommandExecutor executor, Duration connectTimeout, Duration readTimeout) throws Exception {
        Field clientField = HttpCommandExecutor.class.getDeclaredField("client");
        clientField.setAccessible(true);
        HttpClient client = (HttpClient)clientField.get(executor);
        if (client instanceof NettyClient) {
            this.setupTimeouts((NettyClient)client, connectTimeout, readTimeout);
        }
    }

    private void setupTimeouts(NettyClient client, Duration connectTimeout, Duration readTimeout) throws Exception {
        Field configField = NettyClient.class.getDeclaredField("config");
        configField.setAccessible(true);
        Object config = configField.get(client);
        if (config instanceof ClientConfig) {
            this.setupTimeouts((ClientConfig)config, connectTimeout, readTimeout);
        }
    }

    private void setupTimeouts(ClientConfig config, Duration connectTimeout, Duration readTimeout) throws Exception {
        Duration previousConnectTimeout = config.connectionTimeout();
        Duration previousReadTimeout = config.readTimeout();
        config.connectionTimeout(connectTimeout);
        config.readTimeout(readTimeout);
        logger.info("Changed connectTimeout from {} to {}", (Object)previousConnectTimeout, (Object)config.connectionTimeout());
        logger.info("Changed readTimeout from {} to {}", (Object)previousReadTimeout, (Object)config.readTimeout());
    }
}

