/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Html;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

@ParametersAreNonnullByDefault
public class CaseSensitiveText
extends Condition {
    private final String expectedText;

    public CaseSensitiveText(String expectedText) {
        super("textCaseSensitive");
        this.expectedText = expectedText;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        String elementText = "select".equalsIgnoreCase(element.getTagName()) ? this.getSelectedOptionsTexts(element) : element.getText();
        return Html.text.containsCaseSensitive(elementText, this.expectedText);
    }

    private String getSelectedOptionsTexts(WebElement element) {
        List selectedOptions = new Select(element).getAllSelectedOptions();
        return selectedOptions.stream().map(WebElement::getText).collect(Collectors.joining());
    }

    @Override
    public String toString() {
        return String.format("%s '%s'", this.getName(), this.expectedText);
    }
}

