/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.ObjectCondition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.WebDriver;

public class NumberOfWindows
implements ObjectCondition<WebDriver> {
    private final int expectedNumberOfWindows;

    public NumberOfWindows(int expectedNumberOfWindows) {
        this.expectedNumberOfWindows = expectedNumberOfWindows;
    }

    @Override
    @Nonnull
    public String description() {
        return "should have " + this.expectedNumberOfWindows + " window(s)";
    }

    @Override
    @Nonnull
    public String negativeDescription() {
        return "should not have " + this.expectedNumberOfWindows + " window(s)";
    }

    @Override
    public boolean test(WebDriver webDriver) {
        return webDriver.getWindowHandles().size() == this.expectedNumberOfWindows;
    }

    @Override
    @Nullable
    public String actualValue(WebDriver webDriver) {
        return String.valueOf(webDriver.getWindowHandles().size());
    }

    @Override
    @Nonnull
    public String describe(WebDriver webDriver) {
        return "webdriver";
    }
}

