/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.ClickMethod;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ClickOptions {
    private final int offsetX;
    private final int offsetY;
    private final ClickMethod clickMethod;

    private ClickOptions(ClickMethod clickMethod, int offsetX, int offsetY) {
        this.clickMethod = clickMethod;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    @CheckReturnValue
    @Nonnull
    public static ClickOptions usingDefaultMethod() {
        return new ClickOptions(ClickMethod.DEFAULT, 0, 0);
    }

    @CheckReturnValue
    @Nonnull
    public static ClickOptions usingJavaScript() {
        return new ClickOptions(ClickMethod.JS, 0, 0);
    }

    @CheckReturnValue
    public int offsetX() {
        return this.offsetX;
    }

    @CheckReturnValue
    public int offsetY() {
        return this.offsetY;
    }

    @CheckReturnValue
    @Nonnull
    public ClickMethod clickOption() {
        return this.clickMethod;
    }

    @CheckReturnValue
    @Nonnull
    public ClickOptions offsetX(int offsetX) {
        return new ClickOptions(this.clickMethod, offsetX, this.offsetY);
    }

    @CheckReturnValue
    @Nonnull
    public ClickOptions offsetY(int offsetY) {
        return new ClickOptions(this.clickMethod, this.offsetX, offsetY);
    }

    @CheckReturnValue
    @Nonnull
    public ClickOptions offset(int offsetX, int offsetY) {
        return new ClickOptions(this.clickMethod, offsetX, offsetY);
    }

    public String toString() {
        if (this.offsetX == 0 && this.offsetY == 0) {
            return String.format("method: %s", new Object[]{this.clickMethod});
        }
        return String.format("method: %s, offsetX: %s, offsetY: %s", new Object[]{this.clickMethod, this.offsetX, this.offsetY});
    }
}

