/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.conditions.TextCondition;
import com.codeborne.selenide.impl.Html;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

@ParametersAreNonnullByDefault
public class CaseSensitiveText
extends TextCondition {
    public CaseSensitiveText(String expectedText) {
        super("text case sensitive", expectedText);
    }

    @Override
    protected boolean match(String actualText, String expectedText) {
        return Html.text.containsCaseSensitive(actualText, expectedText);
    }

    @Override
    @Nullable
    protected String getText(Driver driver, WebElement element) {
        return "select".equalsIgnoreCase(element.getTagName()) ? this.getSelectedOptionsTexts(element) : element.getText();
    }

    private String getSelectedOptionsTexts(WebElement element) {
        List selectedOptions = new Select(element).getAllSelectedOptions();
        return selectedOptions.stream().map(WebElement::getText).collect(Collectors.joining());
    }
}

