/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.FileNamer;
import com.codeborne.selenide.webdriver.DriverFactory;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public abstract class AbstractDriverFactory
implements DriverFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractDriverFactory.class);
    private static final Pattern REGEX_SIGNED_INTEGER = Pattern.compile("^-?\\d+$");
    private static final Pattern REGEX_VERSION = Pattern.compile("(\\d+)(\\..*)?");
    private final FileNamer fileNamer = new FileNamer();

    @CheckReturnValue
    @Nonnull
    protected File webdriverLog(Config config) {
        File logFolder = FileHelper.ensureFolderExists(new File(config.reportsFolder()).getAbsoluteFile());
        String logFileName = String.format("webdriver.%s.log", this.fileNamer.generateFileName());
        File logFile = new File(logFolder, logFileName).getAbsoluteFile();
        log.info("Write webdriver logs to: {}", (Object)logFile);
        return logFile;
    }

    protected <DS extends DriverService, B extends DriverService.Builder<DS, ?>> DS withLog(Config config, B dsBuilder) {
        if (config.webdriverLogsEnabled()) {
            dsBuilder.withLogFile(this.webdriverLog(config));
        }
        return (DS)dsBuilder.build();
    }

    @CheckReturnValue
    @Nonnull
    protected MutableCapabilities createCommonCapabilities(Config config, Browser browser, @Nullable Proxy proxy) {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        if (proxy != null) {
            capabilities.setCapability("proxy", (Object)proxy);
        }
        if (config.browserVersion() != null && !config.browserVersion().isEmpty()) {
            capabilities.setVersion(config.browserVersion());
        }
        capabilities.setCapability("pageLoadStrategy", config.pageLoadStrategy());
        capabilities.setCapability("acceptSslCerts", true);
        if (browser.supportsInsecureCerts()) {
            capabilities.setCapability("acceptInsecureCerts", true);
        }
        capabilities.setJavascriptEnabled(true);
        capabilities.setCapability("takesScreenshot", true);
        capabilities.setCapability("handlesAlerts", true);
        this.transferCapabilitiesFromSystemProperties(capabilities);
        return capabilities.merge((Capabilities)config.browserCapabilities());
    }

    protected void transferCapabilitiesFromSystemProperties(DesiredCapabilities currentBrowserCapabilities) {
        String prefix = "capabilities.";
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            log.debug("Use {}={}", (Object)key, (Object)value);
            currentBrowserCapabilities.setCapability(capability, this.convertStringToNearestObjectType(value));
        }
    }

    @CheckReturnValue
    @Nonnull
    protected Object convertStringToNearestObjectType(String value) {
        if (this.isBoolean(value)) {
            return Boolean.valueOf(value);
        }
        if (this.isInteger(value)) {
            return Integer.parseInt(value);
        }
        return value;
    }

    @CheckReturnValue
    protected boolean isInteger(String value) {
        return REGEX_SIGNED_INTEGER.matcher(value).matches();
    }

    @CheckReturnValue
    protected boolean isBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
    }

    @CheckReturnValue
    protected boolean isSystemPropertyNotSet(String key) {
        return StringUtils.isBlank((CharSequence)System.getProperty(key, ""));
    }

    @CheckReturnValue
    protected int majorVersion(@Nullable String browserVersion) {
        if (StringUtils.isBlank((CharSequence)browserVersion)) {
            return 0;
        }
        Matcher matcher = REGEX_VERSION.matcher(browserVersion);
        return matcher.matches() ? Integer.parseInt(matcher.replaceFirst("$1")) : 0;
    }

    protected <T> T cast(Object value) {
        return (T)value;
    }
}

