/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.ElementShould;
import com.codeborne.selenide.ex.ElementShouldNot;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.ElementFinder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public abstract class WebElementSource {
    @Nonnull
    private Alias alias = Alias.NONE;

    @CheckReturnValue
    @Nonnull
    public abstract Driver driver();

    @CheckReturnValue
    @Nonnull
    public abstract WebElement getWebElement();

    @CheckReturnValue
    @Nonnull
    public abstract String getSearchCriteria();

    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }

    @CheckReturnValue
    @Nonnull
    public Alias getAlias() {
        return this.alias;
    }

    @CheckReturnValue
    @Nonnull
    public String description() {
        return this.alias.getOrElse(this::getSearchCriteria);
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return this.description();
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return ElementFinder.wrap(this.driver(), this, WebElementSource.getSelector(arg), index);
    }

    @CheckReturnValue
    @Nonnull
    public List<WebElement> findAll() throws IndexOutOfBoundsException {
        return Collections.singletonList(this.getWebElement());
    }

    @CheckReturnValue
    @Nonnull
    public ElementNotFound createElementNotFoundError(Condition condition, Throwable lastError) {
        return new ElementNotFound(this.description(), condition, lastError);
    }

    @CheckReturnValue
    @Nonnull
    public static By getSelector(Object arg) {
        return arg instanceof By ? (By)arg : By.cssSelector((String)((String)arg));
    }

    @Nullable
    public WebElement checkCondition(String prefix, Condition condition, boolean invert) {
        Condition check = invert ? Condition.not(condition) : condition;
        Object lastError = null;
        WebElement element = null;
        try {
            element = this.getWebElement();
            if (check.apply(this.driver(), element)) {
                return element;
            }
        }
        catch (AssertionError | IndexOutOfBoundsException | WebDriverException e) {
            lastError = e;
        }
        if (lastError != null && Cleanup.of.isInvalidSelectorError((Throwable)lastError)) {
            throw Cleanup.of.wrapInvalidSelectorException((Throwable)lastError);
        }
        if (element == null) {
            if (!check.missingElementSatisfiesCondition()) {
                throw this.createElementNotFoundError(check, (Throwable)lastError);
            }
        } else {
            if (invert) {
                throw new ElementShouldNot(this.driver(), this.description(), prefix, condition, element, (Throwable)lastError);
            }
            throw new ElementShould(this.driver(), this.description(), prefix, condition, element, (Throwable)lastError);
        }
        return null;
    }

    @CheckReturnValue
    @Nonnull
    public WebElement findAndAssertElementIsInteractable() {
        return Objects.requireNonNull(this.checkCondition("be ", Condition.or("visible or transparent", Condition.visible, Condition.have(Condition.cssValue("opacity", "0")), new Condition[0]), false));
    }
}

