/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;

public class ShadowRoot
extends By
implements Serializable {
    @CheckReturnValue
    @Nonnull
    public List<WebElement> findElements(SearchContext context) {
        if (context instanceof WrapsDriver) {
            WebDriver driver = ((WrapsDriver)context).getWrappedDriver();
            WebElement shadowRoot = (WebElement)((JavascriptExecutor)driver).executeScript("return arguments[0].shadowRoot", new Object[]{context});
            return Collections.singletonList(shadowRoot);
        }
        throw new IllegalArgumentException("Cannot find shadow root of " + context);
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return "#shadow-root";
    }
}

