/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.impl.ThreadLocalSelenideDriver;
import com.codeborne.selenide.impl.WebDriverContainer;
import com.codeborne.selenide.impl.WebDriverThreadLocalContainer;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

@ParametersAreNonnullByDefault
public class WebDriverRunner {
    public static WebDriverContainer webdriverContainer = new WebDriverThreadLocalContainer();
    private static final SelenideDriver staticSelenideDriver = new ThreadLocalSelenideDriver();

    public static void addListener(WebDriverEventListener listener) {
        webdriverContainer.addListener(listener);
    }

    public static void setWebDriver(WebDriver webDriver) {
        webdriverContainer.setWebDriver(webDriver);
    }

    public static void setWebDriver(WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy) {
        webdriverContainer.setWebDriver(webDriver, selenideProxy);
    }

    public static void setWebDriver(WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy, DownloadsFolder browserDownloadsFolder) {
        webdriverContainer.setWebDriver(webDriver, selenideProxy, browserDownloadsFolder);
    }

    @CheckReturnValue
    @Nonnull
    public static WebDriver getWebDriver() {
        return webdriverContainer.getWebDriver();
    }

    public static void setProxy(Proxy webProxy) {
        webdriverContainer.setProxy(webProxy);
    }

    @CheckReturnValue
    @Nonnull
    public static WebDriver getAndCheckWebDriver() {
        return webdriverContainer.getAndCheckWebDriver();
    }

    @CheckReturnValue
    @Nullable
    public static SelenideProxyServer getSelenideProxy() {
        return webdriverContainer.getProxyServer();
    }

    @CheckReturnValue
    @Nonnull
    static SelenideDriver getSelenideDriver() {
        return staticSelenideDriver;
    }

    @CheckReturnValue
    @Nonnull
    public static Driver driver() {
        return WebDriverRunner.getSelenideDriver().driver();
    }

    @CheckReturnValue
    @Nonnull
    public static DownloadsFolder getBrowserDownloadsFolder() {
        return webdriverContainer.getBrowserDownloadsFolder();
    }

    public static void closeWindow() {
        webdriverContainer.closeWindow();
    }

    public static void closeWebDriver() {
        webdriverContainer.closeWebDriver();
    }

    @CheckReturnValue
    public static boolean hasWebDriverStarted() {
        return webdriverContainer.hasWebDriverStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void using(WebDriver driver, Runnable lambda) {
        if (WebDriverRunner.hasWebDriverStarted()) {
            WebDriver previous = WebDriverRunner.getWebDriver();
            try {
                lambda.run();
            }
            finally {
                WebDriverRunner.setWebDriver(previous);
            }
        }
        WebDriverRunner.setWebDriver(driver);
        try {
            lambda.run();
        }
        finally {
            webdriverContainer.resetWebDriver();
        }
    }

    @CheckReturnValue
    @Nonnull
    private static Browser browser() {
        return new Browser(Configuration.browser, Configuration.headless);
    }

    @CheckReturnValue
    public static boolean isFirefox() {
        return WebDriverRunner.browser().isFirefox();
    }

    @CheckReturnValue
    public static boolean isLegacyFirefox() {
        return WebDriverRunner.browser().isLegacyFirefox();
    }

    @CheckReturnValue
    public static boolean isChrome() {
        return WebDriverRunner.browser().isChrome();
    }

    @CheckReturnValue
    public static boolean isIE() {
        return WebDriverRunner.browser().isIE();
    }

    @CheckReturnValue
    public static boolean isEdge() {
        return WebDriverRunner.browser().isEdge();
    }

    @CheckReturnValue
    public static boolean isHeadless() {
        return WebDriverRunner.browser().isHeadless();
    }

    @CheckReturnValue
    public static boolean supportsJavascript() {
        return WebDriverRunner.driver().supportsJavascript();
    }

    @CheckReturnValue
    public static boolean isOpera() {
        return WebDriverRunner.browser().isOpera();
    }

    public static void clearBrowserCache() {
        webdriverContainer.clearBrowserCache();
    }

    @CheckReturnValue
    @Nonnull
    public static String source() {
        return webdriverContainer.getPageSource();
    }

    @CheckReturnValue
    @Nonnull
    public static String url() {
        return webdriverContainer.getCurrentUrl();
    }

    @CheckReturnValue
    @Nonnull
    public static String currentFrameUrl() {
        return webdriverContainer.getCurrentFrameUrl();
    }
}

