/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.ex.ElementWithTextNotFound;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ItemWithText
extends CollectionCondition {
    private final String expectedText;

    public ItemWithText(String expectedText) {
        this.expectedText = expectedText;
    }

    @Override
    @CheckReturnValue
    public boolean test(List<WebElement> elements) {
        return ElementsCollection.texts(elements).contains(this.expectedText);
    }

    @Override
    public void fail(CollectionSource collection, @Nullable List<WebElement> elements, @Nullable Exception lastError, long timeoutMs) {
        throw new ElementWithTextNotFound(collection, Collections.singletonList(this.expectedText), ElementsCollection.texts(elements), this.explanation, timeoutMs, lastError);
    }

    @Override
    @CheckReturnValue
    public boolean missingElementSatisfiesCondition() {
        return false;
    }

    @CheckReturnValue
    public String toString() {
        return "Text " + this.expectedText;
    }
}

