/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.conditions.Not;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class And
extends Condition {
    private final List<? extends Condition> conditions;
    private Condition lastFailedCondition;

    public And(String name, List<? extends Condition> conditions) {
        super(name, And.checkedConditionsListCtorArg(conditions).stream().allMatch(Condition::missingElementSatisfiesCondition));
        this.conditions = conditions;
    }

    private static List<? extends Condition> checkedConditionsListCtorArg(List<? extends Condition> conditions) {
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("conditions list is empty");
        }
        return conditions;
    }

    @Override
    @Nonnull
    public Condition negate() {
        return new Not(this, this.conditions.stream().map(Condition::negate).allMatch(Condition::missingElementSatisfiesCondition));
    }

    @Override
    @CheckReturnValue
    public boolean apply(Driver driver, WebElement element) {
        this.lastFailedCondition = null;
        for (Condition condition : this.conditions) {
            if (condition.apply(driver, element)) continue;
            this.lastFailedCondition = condition;
            return false;
        }
        return true;
    }

    @Override
    @CheckReturnValue
    public String actualValue(Driver driver, WebElement element) {
        return this.lastFailedCondition == null ? null : this.lastFailedCondition.actualValue(driver, element);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return this.getName() + ": " + this.conditions.stream().map(Condition::toString).collect(Collectors.joining(" and "));
    }
}

