/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.conditions.TextCondition;
import com.codeborne.selenide.impl.Html;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

@ParametersAreNonnullByDefault
public class Text
extends TextCondition {
    public Text(String text) {
        super("text", text);
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("Argument must not be null or empty string. Use $.shouldBe(empty) or $.shouldHave(exactText(\"\").");
        }
    }

    @Override
    protected boolean match(String actualText, String expectedText) {
        return Html.text.contains(actualText, expectedText.toLowerCase());
    }

    @Override
    @Nullable
    protected String getText(Driver driver, WebElement element) {
        return "select".equalsIgnoreCase(element.getTagName()) ? this.getSelectedOptionsTexts(element) : element.getText();
    }

    private String getSelectedOptionsTexts(WebElement element) {
        List selectedOptions = new Select(element).getAllSelectedOptions();
        return selectedOptions.stream().map(WebElement::getText).collect(Collectors.joining());
    }
}

