/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ex.ElementIsNotClickableException;
import com.codeborne.selenide.ex.InvalidStateException;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.WebElementSource;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;

@ParametersAreNonnullByDefault
class ExceptionWrapper {
    ExceptionWrapper() {
    }

    @CheckReturnValue
    @Nonnull
    Throwable wrap(Throwable lastError, WebElementSource webElementSource) {
        if (lastError instanceof UIAssertionError) {
            return lastError;
        }
        if (lastError instanceof InvalidElementStateException) {
            return new InvalidStateException(lastError);
        }
        if (this.isElementNotClickableException(lastError)) {
            return new ElementIsNotClickableException(lastError);
        }
        if (lastError instanceof StaleElementReferenceException || lastError instanceof NotFoundException) {
            return webElementSource.createElementNotFoundError(Condition.exist, lastError);
        }
        return lastError;
    }

    @CheckReturnValue
    private boolean isElementNotClickableException(Throwable e) {
        return e instanceof WebDriverException && e.getMessage().contains("is not clickable");
    }
}

