/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideWait;
import com.codeborne.selenide.ex.AlertNotFoundException;
import com.codeborne.selenide.ex.FrameNotFoundException;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.ex.WindowNotFoundException;
import com.codeborne.selenide.impl.Lists;
import com.codeborne.selenide.impl.windows.FrameByIdOrName;
import com.codeborne.selenide.impl.windows.WindowByIndex;
import com.codeborne.selenide.impl.windows.WindowByNameOrHandle;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Alert;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;

@ParametersAreNonnullByDefault
public class SelenideTargetLocator
implements WebDriver.TargetLocator {
    private static final String SWITCH_TO = SelenideLogger.getReadableSubject("switchTo", new Object[0]);
    private final Driver driver;
    private final WebDriver webDriver;
    private final Config config;
    private final WebDriver.TargetLocator delegate;

    public SelenideTargetLocator(Driver driver) {
        this.driver = driver;
        this.config = driver.config();
        this.webDriver = driver.getWebDriver();
        this.delegate = this.webDriver.switchTo();
    }

    @Nonnull
    public WebDriver frame(int index) {
        return SelenideLogger.get(String.format("frame(index: %s)", index), SWITCH_TO, () -> {
            try {
                return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((int)index));
            }
            catch (NoSuchElementException | TimeoutException e) {
                throw this.frameNotFoundError("No frame found with index: " + index, e);
            }
            catch (InvalidArgumentException e) {
                if (this.isFirefox62Bug(e) || this.isChrome75Error(e)) {
                    throw this.frameNotFoundError("No frame found with index: " + index, e);
                }
                throw e;
            }
        });
    }

    @Nonnull
    public WebDriver frame(String nameOrId) {
        return SelenideLogger.get("frame(" + nameOrId + ")", SWITCH_TO, () -> {
            try {
                return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)nameOrId));
            }
            catch (NoSuchElementException | TimeoutException e) {
                throw this.frameNotFoundError("No frame found with id/name: " + nameOrId, e);
            }
            catch (InvalidArgumentException e) {
                if (this.isFirefox62Bug(e)) {
                    throw this.frameNotFoundError("No frame found with id/name: " + nameOrId, e);
                }
                throw e;
            }
        });
    }

    @Nonnull
    public WebDriver frame(WebElement frameElement) {
        return SelenideLogger.get(String.format("frame(%s)", frameElement), SWITCH_TO, () -> {
            try {
                return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((WebElement)frameElement));
            }
            catch (NoSuchElementException | TimeoutException e) {
                throw this.frameNotFoundError("No frame found with element: " + frameElement, e);
            }
            catch (InvalidArgumentException e) {
                if (this.isFirefox62Bug(e)) {
                    throw this.frameNotFoundError("No frame found with element: " + frameElement, e);
                }
                throw e;
            }
        });
    }

    private boolean isFirefox62Bug(InvalidArgumentException e) {
        return e.getMessage().contains("untagged enum FrameId");
    }

    private boolean isChrome75Error(InvalidArgumentException e) {
        return e.getMessage().contains("invalid argument: 'id' out of range");
    }

    @Nonnull
    public WebDriver parentFrame() {
        return SelenideLogger.get("parent frame", SWITCH_TO, () -> ((WebDriver.TargetLocator)this.delegate).parentFrame());
    }

    @Nonnull
    public WebDriver defaultContent() {
        return SelenideLogger.get("default context", SWITCH_TO, () -> ((WebDriver.TargetLocator)this.delegate).defaultContent());
    }

    @Nonnull
    public WebElement activeElement() {
        return SelenideLogger.get("active element", SWITCH_TO, () -> ((WebDriver.TargetLocator)this.delegate).activeElement());
    }

    @Nonnull
    public Alert alert() {
        try {
            return (Alert)this.Wait().until((Function)ExpectedConditions.alertIsPresent());
        }
        catch (TimeoutException e) {
            throw this.alertNotFoundError(e);
        }
    }

    public void innerFrame(String firstFrame, String ... otherFrames) {
        this.defaultContent();
        for (String frame : Lists.list(firstFrame, otherFrames)) {
            SelenideLogger.run(String.format("frame(%s)", frame), SWITCH_TO, () -> {
                try {
                    this.Wait().until((Function)((Object)new FrameByIdOrName(frame)));
                }
                catch (NoSuchElementException | TimeoutException e) {
                    throw this.frameNotFoundError("No frame found with id/name = " + frame, e);
                }
            });
        }
    }

    @Nonnull
    public WebDriver window(int index) {
        return this.window(this.Wait(), index);
    }

    @Nonnull
    public WebDriver window(int index, Duration duration) {
        return this.window(this.Wait(duration), index);
    }

    @Nonnull
    public WebDriver window(String nameOrHandleOrTitle) {
        return this.window(this.Wait(), nameOrHandleOrTitle);
    }

    @Nonnull
    public WebDriver window(String nameOrHandleOrTitle, Duration duration) {
        return this.window(this.Wait(duration), nameOrHandleOrTitle);
    }

    private WebDriver window(SelenideWait wait, int index) {
        return SelenideLogger.get(String.format("window(index: %s)", index), SWITCH_TO, () -> {
            try {
                return (WebDriver)wait.until((Function)((Object)new WindowByIndex(index)));
            }
            catch (TimeoutException e) {
                throw this.windowNotFoundError("No window found with index: " + index, e);
            }
        });
    }

    private WebDriver window(SelenideWait wait, String nameOrHandleOrTitle) {
        return SelenideLogger.get(String.format("window(%s)", nameOrHandleOrTitle), SWITCH_TO, () -> {
            try {
                return (WebDriver)wait.until((Function)((Object)new WindowByNameOrHandle(nameOrHandleOrTitle)));
            }
            catch (TimeoutException e) {
                throw this.windowNotFoundError("No window found with name or handle or title: " + nameOrHandleOrTitle, e);
            }
        });
    }

    private SelenideWait Wait() {
        return new SelenideWait(this.webDriver, this.config.timeout(), this.config.pollingInterval());
    }

    private SelenideWait Wait(Duration timeout) {
        return new SelenideWait(this.webDriver, timeout.toMillis(), this.config.pollingInterval());
    }

    private Error frameNotFoundError(String message, Throwable cause) {
        FrameNotFoundException error = new FrameNotFoundException(message, cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), this.config.timeout());
    }

    private Error windowNotFoundError(String message, Throwable cause) {
        WindowNotFoundException error = new WindowNotFoundException(message, cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), this.config.timeout());
    }

    private Error alertNotFoundError(Throwable cause) {
        AlertNotFoundException error = new AlertNotFoundException(cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), this.config.timeout());
    }
}

