/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.ScreenShotLaboratory;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class ErrorMessages {
    protected static String timeout(long timeoutMs) {
        if (timeoutMs < 1000L) {
            return "\nTimeout: " + timeoutMs + " ms.";
        }
        if (timeoutMs % 1000L == 0L) {
            return "\nTimeout: " + timeoutMs / 1000L + " s.";
        }
        return "\nTimeout: " + String.format("%.3f", (double)timeoutMs / 1000.0) + " s.";
    }

    static String actualValue(Condition condition, Driver driver, WebElement element) {
        if (element != null) {
            try {
                String actualValue = condition.actualValue(driver, element);
                if (actualValue != null) {
                    return "\nActual value: " + actualValue;
                }
            }
            catch (RuntimeException failedToGetValue) {
                String failedActualValue = failedToGetValue.getClass().getSimpleName() + ": " + failedToGetValue.getMessage();
                return "\nActual value: " + StringUtils.substring((String)failedActualValue, (int)0, (int)50);
            }
        }
        return "";
    }

    public static String screenshot(Driver driver) {
        return ErrorMessages.screenshot(driver.config(), ScreenShotLaboratory.getInstance().formatScreenShotPath(driver));
    }

    public static String screenshot(Config config, String screenshotPath) {
        if (!config.screenshots()) {
            return "";
        }
        if (screenshotPath == null || screenshotPath.isEmpty()) {
            return "\nScreenshot: " + screenshotPath;
        }
        if (config.savePageSource() && !screenshotPath.endsWith(".html")) {
            String htmlFilePath = ErrorMessages.getHtmlFilePath(screenshotPath);
            return "\nScreenshot: " + screenshotPath + "\nPage source: " + htmlFilePath;
        }
        if (screenshotPath.endsWith(".html")) {
            return "\nPage source: " + screenshotPath;
        }
        return "\nScreenshot: " + screenshotPath;
    }

    static String causedBy(Throwable cause) {
        if (cause == null) {
            return "";
        }
        if (cause instanceof WebDriverException) {
            return "\nCaused by: " + Cleanup.of.webdriverExceptionMessage(cause);
        }
        return "\nCaused by: " + cause;
    }

    private static String getHtmlFilePath(String screenshotPath) {
        return screenshotPath.substring(0, screenshotPath.lastIndexOf(46)) + ".html";
    }
}

