/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaOptions;

class OperaDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(OperaDriverFactory.class.getName());

    OperaDriverFactory() {
    }

    @Override
    boolean supports(Config config, Browser browser) {
        return browser.isOpera();
    }

    @Override
    WebDriver create(Config config, Proxy proxy) {
        OperaOptions operaOptions = this.createOperaOptions(config, proxy);
        return new OperaDriver(operaOptions);
    }

    OperaOptions createOperaOptions(Config config, Proxy proxy) {
        OperaOptions operaOptions = new OperaOptions();
        if (config.headless()) {
            throw new InvalidArgumentException("headless browser not supported in Opera. Set headless property to false.");
        }
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: " + config.browserBinary());
            operaOptions.setBinary(config.browserBinary());
        }
        operaOptions.merge((Capabilities)this.createCommonCapabilities(config, proxy));
        return operaOptions;
    }
}

