/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.UnreachableBrowserException;

class CloseBrowser
implements Runnable {
    private static final Logger log = Logger.getLogger(CloseBrowser.class.getName());
    private final WebDriver webdriver;
    private final SelenideProxyServer proxy;

    CloseBrowser(WebDriver webdriver, SelenideProxyServer proxy) {
        this.webdriver = webdriver;
        this.proxy = proxy;
    }

    @Override
    public void run() {
        try {
            log.info("Trying to close the browser " + this.webdriver.getClass().getSimpleName() + " ...");
            this.webdriver.quit();
        }
        catch (UnreachableBrowserException e) {
            log.log(Level.FINE, "Browser is unreachable", e);
        }
        catch (WebDriverException cannotCloseBrowser) {
            log.severe("Cannot close browser normally: " + Cleanup.of.webdriverExceptionMessage(cannotCloseBrowser));
        }
        if (this.proxy != null) {
            log.info("Trying to shutdown " + this.proxy + " ...");
            this.proxy.shutdown();
        }
    }
}

