/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.drivercommands.BrowserHealthChecker;
import com.codeborne.selenide.drivercommands.CloseDriverCommand;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.openqa.selenium.WebDriver;
import org.testng.internal.Nullable;

public class WebDriverWrapper
implements Driver {
    private static final Logger log = Logger.getLogger(WebDriverWrapper.class.getName());
    private final Config config;
    private final WebDriver webDriver;
    private final SelenideProxyServer selenideProxy;
    private final BrowserHealthChecker browserHealthChecker;

    public WebDriverWrapper(@Nonnull Config config, @Nonnull WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy) {
        this(config, webDriver, selenideProxy, new BrowserHealthChecker());
    }

    WebDriverWrapper(@Nonnull Config config, @Nonnull WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy, @Nonnull BrowserHealthChecker browserHealthChecker) {
        Objects.requireNonNull(config, "config must not be null");
        Objects.requireNonNull(webDriver, "webDriver must not be null");
        this.config = config;
        this.webDriver = webDriver;
        this.selenideProxy = selenideProxy;
        this.browserHealthChecker = browserHealthChecker;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public Browser browser() {
        return new Browser(this.config.browser(), this.config.headless());
    }

    @Override
    public boolean hasWebDriverStarted() {
        return this.webDriver != null;
    }

    @Override
    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    @Override
    public SelenideProxyServer getProxy() {
        return this.selenideProxy;
    }

    @Override
    public WebDriver getAndCheckWebDriver() {
        if (this.webDriver != null && !this.browserHealthChecker.isBrowserStillOpen(this.webDriver)) {
            log.info("Webdriver has been closed meanwhile");
            this.close();
            return null;
        }
        return this.webDriver;
    }

    @Override
    public void close() {
        if (!this.config.holdBrowserOpen()) {
            new CloseDriverCommand(this.webDriver, this.selenideProxy).run();
        }
    }
}

