/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.drivercommands.BrowserHealthChecker;
import com.codeborne.selenide.drivercommands.CloseDriverCommand;
import com.codeborne.selenide.drivercommands.CreateDriverCommand;
import com.codeborne.selenide.impl.StaticConfig;
import com.codeborne.selenide.impl.UnusedWebdriversCleanupThread;
import com.codeborne.selenide.impl.WebDriverContainer;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.codeborne.selenide.webdriver.WebDriverFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebDriverThreadLocalContainer
implements WebDriverContainer {
    private static final Logger log = Logger.getLogger(WebDriverThreadLocalContainer.class.getName());
    private final List<WebDriverEventListener> listeners = new ArrayList<WebDriverEventListener>();
    private final Collection<Thread> allWebDriverThreads = new ConcurrentLinkedQueue<Thread>();
    private final Map<Long, WebDriver> threadWebDriver = new ConcurrentHashMap<Long, WebDriver>(4);
    private final Map<Long, SelenideProxyServer> threadProxyServer = new ConcurrentHashMap<Long, SelenideProxyServer>(4);
    private Proxy userProvidedProxy;
    private final BrowserHealthChecker browserHealthChecker = new BrowserHealthChecker();
    private final WebDriverFactory factory = new WebDriverFactory();
    private final AtomicBoolean cleanupThreadStarted = new AtomicBoolean(false);

    @Override
    public void addListener(WebDriverEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void setWebDriver(WebDriver webDriver) {
        this.setWebDriver(webDriver, null);
    }

    private <K, V> void runIfPresent(Map<K, V> map, K key, Consumer<V> lambda) {
        V value = map.get(key);
        if (value != null) {
            lambda.accept(value);
        }
    }

    @Override
    public void setWebDriver(@Nonnull WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy) {
        long threadId = Thread.currentThread().getId();
        this.threadProxyServer.remove(threadId);
        this.threadWebDriver.remove(threadId);
        if (selenideProxy != null) {
            this.threadProxyServer.put(threadId, selenideProxy);
        }
        this.threadWebDriver.put(threadId, webDriver);
    }

    @Override
    public void setProxy(Proxy userProvidedProxy) {
        this.userProvidedProxy = userProvidedProxy;
    }

    @Override
    public boolean hasWebDriverStarted() {
        WebDriver webDriver = this.threadWebDriver.get(Thread.currentThread().getId());
        return webDriver != null;
    }

    @Override
    public WebDriver getWebDriver() {
        long threadId = Thread.currentThread().getId();
        if (!this.threadWebDriver.containsKey(threadId)) {
            throw new IllegalStateException("No webdriver is bound to current thread: " + threadId + ". You need to call open(url) first.");
        }
        return this.threadWebDriver.get(threadId);
    }

    @Override
    public WebDriver getAndCheckWebDriver() {
        WebDriver webDriver = this.threadWebDriver.get(Thread.currentThread().getId());
        if (webDriver != null && Configuration.reopenBrowserOnFail && !this.browserHealthChecker.isBrowserStillOpen(webDriver)) {
            log.info("Webdriver has been closed meanwhile. Let's re-create it.");
            this.closeWebDriver();
            webDriver = this.createDriver();
        } else if (webDriver == null) {
            log.info("No webdriver is bound to current thread: " + Thread.currentThread().getId() + " - let's create a new webdriver");
            webDriver = this.createDriver();
        }
        return webDriver;
    }

    private WebDriver createDriver() {
        CreateDriverCommand.Result result = new CreateDriverCommand().createDriver(new StaticConfig(), this.factory, this.userProvidedProxy, this.listeners);
        this.threadWebDriver.put(Thread.currentThread().getId(), result.webDriver);
        if (result.selenideProxyServer != null) {
            this.threadProxyServer.put(Thread.currentThread().getId(), result.selenideProxyServer);
        }
        this.markForAutoClose(Thread.currentThread());
        return result.webDriver;
    }

    @Override
    public SelenideProxyServer getProxyServer() {
        return this.threadProxyServer.get(Thread.currentThread().getId());
    }

    @Override
    public void closeWebDriver() {
        WebDriver driver = this.threadWebDriver.remove(Thread.currentThread().getId());
        SelenideProxyServer proxy = this.threadProxyServer.remove(Thread.currentThread().getId());
        new CloseDriverCommand(driver, proxy).run();
    }

    @Override
    public void clearBrowserCache() {
        if (this.hasWebDriverStarted()) {
            this.getWebDriver().manage().deleteAllCookies();
        }
    }

    @Override
    public String getPageSource() {
        return this.getWebDriver().getPageSource();
    }

    @Override
    public String getCurrentUrl() {
        return this.getWebDriver().getCurrentUrl();
    }

    @Override
    public String getCurrentFrameUrl() {
        return Selenide.executeJavaScript("return window.location.href", new Object[0]).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markForAutoClose(Thread thread) {
        this.allWebDriverThreads.add(thread);
        if (!this.cleanupThreadStarted.get()) {
            WebDriverThreadLocalContainer webDriverThreadLocalContainer = this;
            synchronized (webDriverThreadLocalContainer) {
                if (!this.cleanupThreadStarted.get()) {
                    new UnusedWebdriversCleanupThread(this.allWebDriverThreads, this.threadWebDriver, this.threadProxyServer).start();
                    this.cleanupThreadStarted.set(true);
                }
            }
        }
    }
}

