/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Browsers;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.impl.ThreadLocalSelenideDriver;
import com.codeborne.selenide.impl.WebDriverContainer;
import com.codeborne.selenide.impl.WebDriverThreadLocalContainer;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebDriverRunner
implements Browsers {
    public static WebDriverContainer webdriverContainer = new WebDriverThreadLocalContainer();
    private static final SelenideDriver staticSelenideDriver = new ThreadLocalSelenideDriver();

    public static void addListener(WebDriverEventListener listener) {
        webdriverContainer.addListener(listener);
    }

    public static void setWebDriver(WebDriver webDriver) {
        webdriverContainer.setWebDriver(webDriver);
    }

    public static void setWebDriver(WebDriver webDriver, SelenideProxyServer selenideProxy) {
        webdriverContainer.setWebDriver(webDriver, selenideProxy);
    }

    public static WebDriver getWebDriver() {
        return webdriverContainer.getWebDriver();
    }

    public static void setProxy(Proxy webProxy) {
        webdriverContainer.setProxy(webProxy);
    }

    public static WebDriver getAndCheckWebDriver() {
        return webdriverContainer.getAndCheckWebDriver();
    }

    public static SelenideProxyServer getSelenideProxy() {
        return webdriverContainer.getProxyServer();
    }

    static SelenideDriver getSelenideDriver() {
        return staticSelenideDriver;
    }

    public static Driver driver() {
        return WebDriverRunner.getSelenideDriver().driver();
    }

    public static void closeWindow() {
        webdriverContainer.closeWindow();
    }

    public static void closeWebDriver() {
        webdriverContainer.closeWebDriver();
    }

    public static boolean hasWebDriverStarted() {
        return webdriverContainer.hasWebDriverStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void using(WebDriver driver, Runnable lambda) {
        if (WebDriverRunner.hasWebDriverStarted()) {
            WebDriver previous = WebDriverRunner.getWebDriver();
            try {
                lambda.run();
            }
            finally {
                WebDriverRunner.setWebDriver(previous);
            }
        }
        WebDriverRunner.setWebDriver(driver);
        try {
            lambda.run();
        }
        finally {
            WebDriverRunner.closeWebDriver();
        }
    }

    private static Browser browser() {
        return new Browser(Configuration.browser, Configuration.headless);
    }

    public static boolean isFirefox() {
        return WebDriverRunner.browser().isFirefox();
    }

    public static boolean isLegacyFirefox() {
        return WebDriverRunner.browser().isLegacyFirefox();
    }

    public static boolean isChrome() {
        return WebDriverRunner.browser().isChrome();
    }

    public static boolean isIE() {
        return WebDriverRunner.browser().isIE();
    }

    public static boolean isEdge() {
        return WebDriverRunner.browser().isEdge();
    }

    public static boolean isHeadless() {
        return WebDriverRunner.browser().isHeadless();
    }

    public static boolean supportsJavascript() {
        return WebDriverRunner.driver().supportsJavascript();
    }

    public static boolean isOpera() {
        return WebDriverRunner.browser().isOpera();
    }

    public static void clearBrowserCache() {
        webdriverContainer.clearBrowserCache();
    }

    public static String source() {
        return webdriverContainer.getPageSource();
    }

    public static String url() {
        return webdriverContainer.getCurrentUrl();
    }

    public static String currentFrameUrl() {
        return webdriverContainer.getCurrentFrameUrl();
    }
}

