/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiReportUrl {
    private static final Logger log = LoggerFactory.getLogger(CiReportUrl.class);

    public String getReportsUrl(String reportsUrl) {
        if (!this.isEmpty(reportsUrl)) {
            log.debug("Using variable selenide.reportsUrl={}", (Object)reportsUrl);
            return this.resolveUrlSource(reportsUrl, new Object[0]);
        }
        reportsUrl = this.getJenkinsReportsUrl();
        if (!this.isEmpty(reportsUrl)) {
            log.debug("Using Jenkins BUILD_URL: {}", (Object)reportsUrl);
            return reportsUrl;
        }
        reportsUrl = this.getTeamCityUrl();
        if (!this.isEmpty(reportsUrl)) {
            log.debug("Using Teamcity artifacts url: {}", (Object)reportsUrl);
            return reportsUrl;
        }
        log.debug("Variable selenide.reportsUrl not found");
        return reportsUrl;
    }

    private String getTeamCityUrl() {
        String url = System.getProperty("teamcity.serverUrl");
        String build_type = System.getProperty("teamcity.buildType.id");
        String build_number = System.getProperty("build.number");
        if (this.isEmpty(build_type) || this.isEmpty(build_number) || this.isEmpty(url)) {
            return null;
        }
        return this.resolveUrlSource("%s/repository/download/%s/%s:id/", url, build_type, build_number);
    }

    private String getJenkinsReportsUrl() {
        String build_url = System.getProperty("BUILD_URL");
        if (!this.isEmpty(build_url)) {
            return this.resolveUrlSource("%s/artifact/", build_url);
        }
        return null;
    }

    private String resolveUrlSource(String base, Object ... format) {
        if (format.length != 0) {
            base = String.format(base, format);
        }
        try {
            return new URI(base).normalize().toURL().toString();
        }
        catch (Exception e) {
            log.error("Variable selenide.reportsUrl is incorrect: {}", (Object)base, (Object)e);
            return null;
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

