/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.Waiter;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.proxy.FileDownloadFilter;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFileWithProxyServer {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileWithProxyServer.class);
    private final Waiter waiter;

    DownloadFileWithProxyServer(Waiter waiter) {
        this.waiter = waiter;
    }

    public DownloadFileWithProxyServer() {
        this(new Waiter());
    }

    public File download(WebElementSource anyClickableElement, WebElement clickable, SelenideProxyServer proxyServer, long timeout) throws FileNotFoundException {
        return this.clickAndInterceptFileByProxyServer(anyClickableElement, clickable, proxyServer, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File clickAndInterceptFileByProxyServer(WebElementSource anyClickableElement, WebElement clickable, SelenideProxyServer proxyServer, long timeout) throws FileNotFoundException {
        Config config = anyClickableElement.driver().config();
        WebDriver webDriver = anyClickableElement.driver().getWebDriver();
        String currentWindowHandle = webDriver.getWindowHandle();
        Set currentWindows = webDriver.getWindowHandles();
        FileDownloadFilter filter = (FileDownloadFilter)proxyServer.responseFilter("download");
        filter.activate();
        try {
            clickable.click();
            this.waiter.wait(filter, new HasDownloads(), timeout, config.pollingInterval());
            File file = this.firstDownloadedFile(anyClickableElement, filter, timeout);
            return file;
        }
        finally {
            filter.deactivate();
            this.closeNewWindows(webDriver, currentWindowHandle, currentWindows);
        }
    }

    private void closeNewWindows(WebDriver webDriver, String currentWindowHandle, Set<String> currentWindows) {
        Set windowHandles = webDriver.getWindowHandles();
        if (windowHandles.size() != currentWindows.size()) {
            HashSet newWindows = new HashSet(windowHandles);
            newWindows.removeAll(currentWindows);
            log.info("File has been opened in a new window, let's close {} new windows", (Object)newWindows.size());
            for (String newWindow : newWindows) {
                log.info("  Let's close {}", (Object)newWindow);
                try {
                    webDriver.switchTo().window(newWindow);
                    webDriver.close();
                }
                catch (NoSuchWindowException windowHasBeenClosedMeanwhile) {
                    log.info("  Failed to close {}: {}", (Object)newWindow, (Object)Cleanup.of.webdriverExceptionMessage(windowHasBeenClosedMeanwhile));
                }
                catch (Exception e) {
                    log.warn("  Failed to close {}", (Object)newWindow, (Object)e);
                }
            }
            webDriver.switchTo().window(currentWindowHandle);
        }
    }

    private File firstDownloadedFile(WebElementSource anyClickableElement, FileDownloadFilter filter, long timeout) throws FileNotFoundException {
        List<File> files = filter.getDownloadedFiles();
        if (files.isEmpty()) {
            throw new FileNotFoundException("Failed to download file " + anyClickableElement + " in " + timeout + " ms." + filter.getResponses());
        }
        log.info("Downloaded file: {}", (Object)files.get(0).getAbsolutePath());
        log.info("Just in case, all intercepted responses: {}", (Object)filter.getResponses());
        return files.get(0);
    }

    private static class HasDownloads
    implements Predicate<FileDownloadFilter> {
        private HasDownloads() {
        }

        public boolean apply(FileDownloadFilter filter) {
            return !filter.getDownloadedFiles().isEmpty();
        }
    }
}

