/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.WebDriverProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractDriverFactory.class);

    AbstractDriverFactory() {
    }

    abstract boolean supports(Config var1, Browser var2);

    abstract WebDriver create(Config var1, Proxy var2);

    WebDriver createInstanceOf(String className, Config config, Proxy proxy) {
        try {
            DesiredCapabilities capabilities = this.createCommonCapabilities(config, proxy);
            capabilities.setJavascriptEnabled(true);
            capabilities.setCapability("takesScreenshot", true);
            capabilities.setCapability("handlesAlerts", true);
            Class<?> clazz = Class.forName(className);
            if (WebDriverProvider.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return ((WebDriverProvider)constructor.newInstance(new Object[0])).createDriver(capabilities);
            }
            Constructor<?> constructor = Class.forName(className).getConstructor(Capabilities.class);
            return (WebDriver)constructor.newInstance(capabilities);
        }
        catch (InvocationTargetException e) {
            throw this.runtime(e.getTargetException());
        }
        catch (Exception invalidClassName) {
            throw new IllegalArgumentException(invalidClassName);
        }
    }

    private RuntimeException runtime(Throwable exception) {
        return exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
    }

    DesiredCapabilities createCommonCapabilities(Config config, Proxy proxy) {
        DesiredCapabilities browserCapabilities = new DesiredCapabilities();
        if (proxy != null) {
            browserCapabilities.setCapability("proxy", (Object)proxy);
        }
        if (config.browserVersion() != null && !config.browserVersion().isEmpty()) {
            browserCapabilities.setVersion(config.browserVersion());
        }
        browserCapabilities.setCapability("pageLoadStrategy", config.pageLoadStrategy());
        browserCapabilities.setCapability("acceptSslCerts", true);
        this.transferCapabilitiesFromSystemProperties(browserCapabilities);
        browserCapabilities = this.mergeCapabilitiesFromConfiguration(config, browserCapabilities);
        return browserCapabilities;
    }

    DesiredCapabilities mergeCapabilitiesFromConfiguration(Config config, DesiredCapabilities currentCapabilities) {
        return currentCapabilities.merge((Capabilities)config.browserCapabilities());
    }

    private void transferCapabilitiesFromSystemProperties(DesiredCapabilities currentBrowserCapabilities) {
        String prefix = "capabilities.";
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            log.debug("Use {}={}", (Object)key, (Object)value);
            if (value.equals("true") || value.equals("false")) {
                currentBrowserCapabilities.setCapability(capability, (Object)Boolean.valueOf(value));
                continue;
            }
            if (value.matches("^-?\\d+$")) {
                currentBrowserCapabilities.setCapability(capability, (Object)Integer.parseInt(value));
                continue;
            }
            currentBrowserCapabilities.setCapability(capability, value);
        }
    }
}

